#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Line flameMod01.fsh  by   davidm
//https://www.shadertoy.com/view/MljSWR
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract


vec2 rand(vec2 co){
    return texture(iChannel0, co).rg;
    float x=fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
    float y=fract(sin(dot(co.xy+vec2(3223.21323,-3323.312323) ,vec2(12.9898,78.233))) * 43758.5453);
    return vec2(x,y);
}

vec3 hash( vec3 p ){
	p = vec3( dot(p,vec3(127.1,311.7, 234.6)),
			  dot(p,vec3(269.5,183.3,198.3)),
              dot(p,vec3(169.5,283.3,156.9)));

	vec3 h = (fract(sin(p)*43758.5453123));
    float alpha = acos(2.*h.x-1.);
    float beta = 2.*3.1416*h.y;
    return vec3(cos(beta)*sin(alpha), sin(beta)*cos(alpha), cos(alpha));
}

float blend(float x){
	float x2=x*x;
	float x3=x*x2;
	return 6.*x3*x2-15.*x2*x2+10.*x3;
}

//https://iquilezles.org/articles/palettes
vec3 pal( in float t, in vec3 a, in vec3 b, in vec3 c, in vec3 d )
{
    return a + b*cos( 6.28318*(c*t+d) );
}

float fnoisePerlin(float amp, float freq, float x, float y, float z){
	x=x*freq;
	y=y*freq;
	float fx=floor(x);
	float fy=floor(y);
	float fz=floor(z);
	float cx=ceil(x);
	float cy=ceil(y);
	float cz=ceil(z);
    
	vec3 v000=hash(vec3(fx, fy, fz));
	vec3 v100=hash(vec3(cx, fy, fz));
	vec3 v010=hash(vec3(fx, cy, fz));
	vec3 v110=hash(vec3(cx, cy, fz));
	vec3 v001=hash(vec3(fx, fy, cz));
	vec3 v101=hash(vec3(cx, fy, cz));
	vec3 v011=hash(vec3(fx, cy, cz));
	vec3 v111=hash(vec3(cx, cy, cz));

    
	float a000=dot(v000, vec3(x-fx,y-fy, z-fz));
	float a100=dot(v100, vec3(x-cx,y-fy, z-fz));
	float a010=dot(v010, vec3(x-fx,y-cy, z-fz));
	float a110=dot(v110, vec3(x-cx,y-cy, z-fz));
	
    float a001=dot(v001, vec3(x-fx,y-fy, z-cz));
	float a101=dot(v101, vec3(x-cx,y-fy, z-cz));
	float a011=dot(v011, vec3(x-fx,y-cy, z-cz));
	float a111=dot(v111, vec3(x-cx,y-cy, z-cz));
    
    
    float mx=blend(x-fx);
    float my=blend(y-fy);
    float mz=blend(z-fz);
    
    
    float ix00=mix(a000, a100, mx);
    float ix10=mix(a010, a110, mx);
    float ix01=mix(a001, a101, mx);
    float ix11=mix(a011, a111, mx);
    
    float iy0=mix(ix00,ix10, my);
    float iy1=mix(ix01,ix11, my);
    
    float iz=mix(iy0, iy1, mz);
    
   
	return (amp*iz);
}

float pt(float t){
    vec2 uv = gl_FragCoord.xy/iResolution.y;
    float f=0.;
    float freq=2.5;
    float amp=2.5;
    for (float i=0.; i<3.; i+=1.0){
    	f+=(fnoisePerlin(amp, freq, uv.x,uv.y, t));
        amp*=0.15;
        freq*=2.0;
    }
    return 0.3*max(exp(1.-1.1*abs(f+uv.y*10.-5.)), 0.);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
	vec2 uv = gl_FragCoord.xy/iResolution.xy;
    float t=0.4*iTime;
    vec3 c = vec3(0.);
    c     += 0.99*pt(t+0.0)*pal(uv.x+iTime*0.2,  vec3(0.5,0.5,0.5),vec3(0.5,0.5,0.5),vec3(1.0,1.0,1.0),vec3(0.3,0.20,0.20));
    c     += 0.99*pt(t+0.2)*pal(uv.x+iTime*0.1,vec3(0.5,0.5,0.5),vec3(0.5,0.5,0.5),vec3(2.0,1.0,0.0),vec3(0.5,0.20,0.25));
    fragColor.rgb = c;
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

